<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title>SPPS-APP | Login</title>

  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

  <link rel="icon" type="image/png" href="logo smk.png">

  <link href="<?php echo media_url() ?>css/bootstrap.min.css" rel="stylesheet" />
  <link href="<?php echo media_url() ?>css/font-awesome.min.css" rel="stylesheet" />
  <link href="<?php echo media_url() ?>css/login.css" rel="stylesheet" />

  <style>
    @keyframes typing {
      from {
        width: 0;
      }
      to {
        width: 100%;
      }
    }

    @keyframes blink-caret {
      from, to {
        border-color: transparent;
      }
      50% {
        border-color: black;
      }
    }

    .title-login {
      overflow: hidden;
      border-right: .15em solid black;
      white-space: nowrap;
      margin: 0 auto;
      letter-spacing: .15em;
      animation:
        typing 3.5s steps(30, end),
        blink-caret .75s step-end infinite;
    }

    .form-group {
      position: relative;
    }

    .toggle-password {
      cursor: pointer;
      position: absolute;
      right: 10px; /* Adjusted position */
      top: 50%;
      transform: translateY(-50%);
      font-size: 18px; /* Slightly smaller for better fit */
      color: #007bff; /* Elegant blue color */
      transition: color 0.3s;
    }

    .toggle-password:hover {
      color: #0056b3; /* Darker blue on hover */
    }

    .form-control {
      padding-right: 40px; /* Ensure space for the icon */
    }
  </style>
</head>
<body>
  <div class="row">
    <div class="col-md-5">
      <div class="logo hidden-xs hidden-sm">
        <?php if (isset($setting_logo) AND $setting_logo['setting_value'] == NULL) { ?>
        <img src="<?php echo media_url('img/logo.svg') ?>" class="img-responsive">
        <?php } else { ?>
        <img src="<?php echo upload_url('school/' . $setting_logo['setting_value']) ?>" class="img-responsive">
        <?php } ?>
      </div>
      <p class="merk"><span style="color: #2ABB9B">SPPS</span> APP</p> 
      <?php if (isset($setting_school) AND $setting_school['setting_value'] == '-') { ?>
      <p class="school">Sistem Pembayaran Pendidikan Sekolah</p> 
      <?php } else { ?>
      <p class="school"><?php echo $setting_school['setting_value'] ?></p> 
      <?php } ?>
    </div>
    <div class="col-md-7">
      <div class="box">
        <?php echo form_open('manage/auth/login', array('class'=>'login100-form validate-form')); ?>

        <div class="col-md-12">
          <p class="title-login">Admin Login</p>
          <?php if ($this->session->flashdata('failed')) { ?>
          <br><br>
        <div class="alert alert-danger alert-dismissible" style="margin-top: -85px !important;">
          <h5><i class="fa fa-close"></i> Email atau Password salah!</h5>
        </div>
        <?php  }  ?>
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label>Email</label>
                <input type="email" required="" autofocus="" name="email" placeholder="Masukan email" class="form-control flat">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label>Password</label>
                <input type="password" required="" name="password" id="password" placeholder="Masukan password" class="form-control flat">
                <span class="toggle-password" onclick="togglePassword()">
                  <i class="fa fa-eye" id="toggle-icon" title="Show Password"></i>
                  <i class="fa fa-eye-slash" id="toggle-icon-hidden" title="Hide Password" style="display: none;"></i>
                </span>
              </div>
            </div>
          </div>
          <button class="btn btn-login">Login</button>
        </div>
        <?php echo form_close(); ?>
      </div>
    </div>
  </div>

  <script>
  document.addEventListener("DOMContentLoaded", function() {
    var title = document.querySelector(".title-login");

    function resetAnimation() {
      title.style.animation = 'none';
      title.offsetHeight; /* trigger reflow */
      title.style.animation = null; 
    }

    title.addEventListener("animationend", resetAnimation);
  });

  function togglePassword() {
    var passwordField = document.getElementById("password");
    var toggleIcon = document.getElementById("toggle-icon");
    var toggleIconHidden = document.getElementById("toggle-icon-hidden");

    if (passwordField.type === "password") {
      passwordField.type = "text";
      toggleIcon.style.display = "none";
      toggleIconHidden.style.display = "inline";
    } else {
      passwordField.type = "password";
      toggleIcon.style.display = "inline";
      toggleIconHidden.style.display = "none";
    }
  }
  </script>
</body>
</html>